/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items.module;

import com.st0x0ef.stellaris.common.items.module.SpaceSuitModule;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class OilFinderModule
extends Item
implements SpaceSuitModule {
    int oilLevel = 0;

    public OilFinderModule(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public void tick(ItemStack stack, Level level, Player player) {
        SpaceSuitModule.super.tick(stack, level, player);
        if (!level.isClientSide) {
            this.oilLevel = level.getChunk(player.blockPosition()).stellaris$getChunkOilLevel();
        }
    }

    @Override
    public int renderStackedGui(GuiGraphics graphics, DeltaTracker deltaTracker, Player player, ItemStack stack, int y) {
        graphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("Oil Level: " + this.oilLevel)), 5, y, 0xFFFFFF);
        Objects.requireNonNull(Minecraft.getInstance().font);
        return y += 9;
    }

    @Override
    public MutableComponent displayName() {
        return Component.translatable((String)"spacesuit.stellaris.oil_finder");
    }

    @Override
    public void addToTooltips(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"spacesuit.stellaris.oil_finder"));
    }
}

